/*
 * File: Keyboard.java
 * ======================================================================
 * A program that displays a keyboard that the user can play!
 */

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import acm.program.*;
import acm.util.*;
import acm.graphics.*;

public class Keyboard extends GraphicsProgram {
	/* A nice window size. */
	public static final int APPLICATION_WIDTH = 700;
	public static final int APPLICATION_HEIGHT = 235;
	
	/* The file containing the keyboard layout. */
	private static final String KEYBOARD_FILE = "keyboard.txt";
	
	private HashMap<GObject, AudioClip> noteMap = new HashMap<GObject, AudioClip>();
	
	public void run() {
		addKeyboard();
		addMouseListeners();
	}
	
	private void addKeyboard() {
		try {
			BufferedReader br = new BufferedReader(new FileReader(KEYBOARD_FILE));
			
			while (true) {
				/* Read the key information from the file. */
				String noteName = br.readLine();
				String x = br.readLine();
				String y = br.readLine();
				String width = br.readLine();
				String height = br.readLine();
				String isWhiteKey = br.readLine();
				if (isWhiteKey == null) break;
				
				/* Build up the key. */
				GRect key = new GRect(Double.parseDouble(x),
						              Double.parseDouble(y),
						              Double.parseDouble(width),
						              Double.parseDouble(height));
				key.setFilled(true);
				
				if (isWhiteKey.equals("true"))
					key.setFillColor(Color.WHITE);
				
				add(key);
				
				/* Associate the key with the sound to play. */
				noteMap.put(key, MediaTools.loadAudioClip(noteName));
			}
			
		} catch (IOException e) {
			throw new ErrorException(e);
		}
	}

	/* The currently-pressed note. */
	private GObject selected = null;
	
	/**
	 * When a note is clicked, play its sound.
	 */
	public void mousePressed(MouseEvent e) {
		GObject hit = getElementAt(e.getX(), e.getY());
		if (hit != null) {
			noteMap.get(hit).play();
			selected = hit;
		}
	}
	
	/**
	 * When the mouse is released, stop playing the sound.
	 */
	public void mouseReleased(MouseEvent e) {
		if (selected != null) {
			noteMap.get(selected).stop();
			selected = null;
		}
	}
}
